<?php
header('Access-Control-Allow-Origin: *');
session_start();

require_once 'BancodeDados.php';

if (!isset($pdo)) {
    echo '5'; // Erro de conexão
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['renavam']) || empty($_POST['renavam'])) {
        echo '1'; // Campo obrigatório não enviado
        exit;
    }

    $renavam = $_POST['renavam'];

    // Consulta correta com placeholder
    $sql = "SELECT COUNT(*) as total FROM cad_carro WHERE renavam = :renavam";
    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':renavam', $renavam, PDO::PARAM_STR);
    $stmt->execute();
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row && $row['total'] > 0) {
        echo '3'; // Já existe um carro com esse Renavam (DUPLICADO)
    } else {
        echo '2'; // Não existe, pode cadastrar
    }
} else {
    echo '4'; // Método não permitido
}
?>
