<?php
header('Access-Control-Allow-Origin: *');
session_start();

// Inclui o arquivo de conexão com o banco de dados
require_once 'BancodeDados.php';

// Verifica se a conexão foi estabelecida corretamente
if (!isset($pdo)) {
    die("Erro: Conexão com o banco de dados não estabelecida.");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verifica se todos os campos necessários estão presentes
    $requiredFields = ['datainicio', 'horaInicio', 'datafim', 'horaFim', 'motivo', 'cpfSolicitante', 'carro', 'motorista', 'fileName', 'fileType', 'fileBase64'];
    foreach ($requiredFields as $field) {
        if (!isset($_POST[$field])) {
            die("Erro: Campo '$field' não encontrado.");
        }
    }

    // Recebe os dados do formulário
    $dataInicio = $_POST['datainicio'];
    $horaInicio = $_POST['horaInicio'];
    $dataFim = $_POST['datafim'];
    $horaFim = $_POST['horaFim'];
    $motivo = $_POST['motivo'];
    $carro = $_POST['carro'];
    $motorista = $_POST['motorista'];
    $cpf = $_POST['cpfSolicitante'];
    $fileName = $_POST['fileName'];
    $fileType = $_POST['fileType'];
    $fileBase64 = $_POST['fileBase64']; // Arquivo em Base64

    // Converte a data para o formato YYYY-MM-DD
    $dataInicioObj = DateTime::createFromFormat('Y-m-d', $dataInicio);
    $dataFimObj = DateTime::createFromFormat('Y-m-d', $dataFim);

    // Converte a hora para o formato HH:MM:SS
    $horaInicioObj = DateTime::createFromFormat('H:i', $horaInicio);
    $horaFimObj = DateTime::createFromFormat('H:i', $horaFim);

    // Verifica se a conversão foi bem-sucedida
    if (!$dataInicioObj || !$dataFimObj || !$horaInicioObj || !$horaFimObj) {
        die("Erro: Formato de data ou hora inválido.");
    }

    $dataInicio = $dataInicioObj->format('Y-m-d');
    $dataFim = $dataFimObj->format('Y-m-d');
    $horaInicio = $horaInicioObj->format('H:i:s');
    $horaFim = $horaFimObj->format('H:i:s');

    // Inserir no banco de dados
    $sql = "INSERT INTO solicitacoes (data_inicio, hora_inicio, data_fim, hora_fim, motivo, cpf, carro, motorista, file_name, file_type, file_base64) 
            VALUES (:data_inicio, :hora_inicio, :data_fim, :hora_fim, :motivo,:cpf, :carro, :motorista, :file_name, :file_type, :file_base64)";

    $stmt = $pdo->prepare($sql);

    $stmt->bindParam(':data_inicio', $dataInicio);
    $stmt->bindParam(':hora_inicio', $horaInicio);
    $stmt->bindParam(':data_fim', $dataFim);
    $stmt->bindParam(':hora_fim', $horaFim);
    $stmt->bindParam(':motivo', $motivo);
    $stmt->bindParam(':cpf', $cpf);
    $stmt->bindParam(':carro', $carro);
    $stmt->bindParam(':motorista', $motorista);
    $stmt->bindParam(':file_name', $fileName);
    $stmt->bindParam(':file_type', $fileType);
    $stmt->bindParam(':file_base64', $fileBase64, PDO::PARAM_LOB);

    if ($stmt->execute()) {
        echo '1'; // Sucesso
    } else {
        echo '2'; // Erro
    }
} else {
    echo '2'; // Método não permitido
}
?>