var t;
var obj;
var dadosObj = new Array();
var Obj;
var base64;
var fileName;
moment.locale('pt-br');

function lista () {
    obj = "listarSolicitacoes.php";
    $.getJSON(obj, { format: "json" })
    .done(function(data) {
        console.log(data);

        // Transformar o objeto em um array
        var dataArray = Object.keys(data).map(function(key) {
            return data[key];
        });

        // carregar tabela
        t = $("#tabelaSolicitacoes").DataTable({
            data: dataArray,
            columns: [
                {"data": "id"},
                {"data": "cpf"},
                {
                    "data": "data_cadastro",
                    "render": function(data) {
                        return moment(data).format('DD/MM/YYYY');
                    }
                },
                {
                    "data": "status",
                    "render": function(data, type, row) {
                        var statusBadge = '';
                        if (data === null || data === "Aguardando") {
                            statusBadge = '<span class="badge bg-warning" style="background-color: #ffc107;">Aguardando</span>';
                        } else if (data === "Aprovado") {
                            statusBadge = '<span class="badge bg-success" style="background-color: #28a745;">Aprovado</span>';
                        } else if (data === "Reprovado") {
                            statusBadge = '<span class="badge bg-danger" style="background-color: #dc3545;">Reprovado</span>';
                        } else {
                            statusBadge = data;
                        }

                        return statusBadge + 
                            ' <button id="editar2" rel="' + row.id + '" type="button" class="button5" ' +
                            'data-target="#modalEditar" data-toggle="modal" onclick="limpar()">Visualizar</button>';
                    }
                }
            ]
        });
    });
}
lista();

// Função para preencher a modal com os dados
function preencherModalEditar(dado) {
    console.log("Dados recebidos para preenchimento:", dado);
    
    // Preenche os campos de data e hora
    $('#data_inicio').val(dado.data_inicio);
    $('#hora_inicio').val(formatarHora(dado.hora_inicio));
    $('#data_fim').val(dado.data_fim);
    $('#hora_fim').val(formatarHora(dado.hora_fim));
    
    // Preenche os campos de texto
    $('#motivo').val(dado.motivo);
    $('#cpfSolicitante').val(dado.cpf);
    $('#obs').val(dado.obs || '');

    // Preenche o status
    $('#status').val(dado.status === null ? 'null' : dado.status);

    // Armazena os dados do arquivo em variáveis globais
    window.base64 = dado.file_base64;
    window.fileName = dado.file_name;

    // Configura o link de download do arquivo
    if(dado.file_base64 && dado.file_name) {
        $('#downloadLink').attr({
            'href': dado.file_base64,
            'download': dado.file_name
        }).text('Baixar ' + dado.file_name).show();
        
        // Habilita o botão de visualização com os dados corretos
        $('#viewFileBtn').show().off('click').on('click', function(e) {
            e.preventDefault();
            console.log('Clicou para visualizar:', {
                base64: dado.file_base64 ? 'presente' : 'ausente',
                fileName: dado.file_name
            });
            visualizarArquivo(dado.file_base64, dado.file_name);
        });
    } else {
        $('#downloadLink').hide();
        $('#viewFileBtn').hide();
    }

    // Carrega e seleciona corretamente Motorista e Carro
    preencherSelectMotorista(dado.motorista);
    preencherSelectCarro(dado.carro);

    // Armazena o ID para edição
    window.idEditar = dado.id;
    console.log("ID para edição:", window.idEditar);
}
/*
function preencherModalEditar(dado) {
    console.log("Dados recebidos para preenchimento:", dado);
    
    // Preenche os campos de data e hora
    $('#data_inicio').val(dado.data_inicio);
    $('#hora_inicio').val(formatarHora(dado.hora_inicio));
    $('#data_fim').val(dado.data_fim);
    $('#hora_fim').val(formatarHora(dado.hora_fim));
    
    // Preenche os campos de texto
    $('#motivo').val(dado.motivo);
    $('#cpfSolicitante').val(dado.cpf);
    $('#obs').val(dado.obs || '');

    // Preenche o status
    $('#status').val(dado.status === null ? 'null' : dado.status);

    // Configura o link de download do arquivo
    if(dado.file_base64 && dado.file_name) {
        base64 = dado.file_base64;
        fileName = dado.file_name;
        $('#downloadLink').attr({
            'href': dado.file_base64,
            'download': dado.file_name
        }).text('Baixar ' + dado.file_name).show();
    } else {
        base64 = dado.file_base64;
        fileName = dado.file_name;
        $('#downloadLink').hide();
    }

    // Configura o botão de visualização
    $('#viewFile').off('click').on('click', function(e) {
        e.preventDefault();
        visualizarArquivo(dado.file_base64, dado.file_name);
    });
    
    // Carrega e seleciona corretamente Motorista e Carro
    preencherSelectMotorista(dado.motorista);
    preencherSelectCarro(dado.carro);

    // Armazena o ID para edição
    window.idEditar = dado.id;
    console.log("ID para edição:", window.idEditar);
}
*/
// Função auxiliar para formatar hora
function formatarHora(hora) {
    return hora ? hora.substring(0, 5) : '';
}

// --------------------- FUNÇÕES DE SELECT ---------------------

// Função para preencher <select> Motorista
function preencherSelectMotorista(valorSelecionado = null) {
    const selectMotorista = document.getElementById("motorista");

    $.ajax({
        type: 'POST',
        url: 'listarMotorista.php',
        cache: false,
        success: function (d) {
            console.log("Motoristas recebidos:", d);

            while (selectMotorista.options.length > 1) {
                selectMotorista.remove(1);
            }

            if (typeof d === 'string') {
                try {
                    d = JSON.parse(d);
                } catch (e) {
                    console.error("Erro ao fazer parse do JSON motorista:", e);
                    return;
                }
            }

            if (Array.isArray(d) && d.length > 0) {
                d.forEach(motorista => {
                    const option = document.createElement("option");
                    option.value = motorista.cpf; // valor = CPF
                    option.text = `${motorista.nome} - CPF: ${motorista.cpf}`;
                    selectMotorista.appendChild(option);
                });
            } else {
                const option = document.createElement("option");
                option.text = "Nenhum motorista disponível";
                option.disabled = true;
                selectMotorista.appendChild(option);
            }

            if (valorSelecionado) {
                $("#motorista").val(valorSelecionado);
            }
        },
        error: function (xhr, status, error) {
            console.error("Erro ao carregar motoristas:", error);
        }
    });
}

// Função para preencher <select> Carro
function preencherSelectCarro(valorSelecionado = null) {
    const selectCarro = document.getElementById("carro");

    $.ajax({
        type: 'POST',
        url: 'listarCarro.php',
        cache: false,
        success: function (f) {
            console.log("Carros recebidos:", f);

            while (selectCarro.options.length > 1) {
                selectCarro.remove(1);
            }

            if (typeof f === 'string') {
                try {
                    f = JSON.parse(f);
                } catch (e) {
                    console.error("Erro ao fazer parse do JSON carro:", e);
                    return;
                }
            }

            if (Array.isArray(f) && f.length > 0) {
                f.forEach(carro => {
                    const option = document.createElement("option");
                    option.value = carro.renavam; // valor = Renavam
                    option.text = `${carro.marca_modelo} - Renavam: ${carro.renavam}`;
                    selectCarro.appendChild(option);
                });
            } else {
                const option = document.createElement("option");
                option.text = "Nenhum carro disponível";
                option.disabled = true;
                selectCarro.appendChild(option);
            }

            if (valorSelecionado) {
                $("#carro").val(valorSelecionado);
            }
        },
        error: function (xhr, status, error) {
            console.error("Erro ao carregar carros:", error);
        }
    });
}

// --------------------- EVENTOS ---------------------

$('#tabelaSolicitacoes').on('click', 'tr', function() {
    if (t) {
        var dado = t.row($(this)).data();
        preencherModalEditar(dado);
    }
});

//Deletar dados do usuário da tela solicitacoes
function deletarSolicitacoes(){
console.log("Deletar solicitações");       
    console.log('id=' + idEditar);
    
    alertify.confirm('Essa ação não poderá ser desfeita. Você deseja deletar?',
      function (e) {
          if (e) {
              console.log('Sim'); // Executa se o usuário clicar em "Sim"
              $.ajax({                    
                type: 'POST',//método                  
                url: 'deletarsolicitacoes.php',
                cache: false,
                data: { id: idEditar },
                          
                success:function (d) {
                    console.log("entrei no ajax");
                    console.log(d);            
                    if(d=='3'){
    
                    //console.log('3');
                    setTextoNoAlert('alert btn-success text-center text-white textWhite', 'Sucesso ao Deletar!');
                    setTimeout("limpar()", 6000);
                    setTimeout("window.location.href='solicitacoes.php'", 7000);
    
                    }
                    else{
    
                      //console.log('2');
                      setTextoNoAlert('alert btn-danger text-center text-white textWhite', 'Erro ao Deletar!');
                      setTimeout("limpar()", 9000);
                      setTimeout("window.location.href='solicitacoes.php'", 10000);
    
                    }
                  }
              });
          } 
      }
  ).set('labels', {ok: 'Sim', cancel: 'Não'});
  // Seleciona o elemento do cabeçalho
  const header = document.querySelector('.ajs-header');
  // Altera o texto para "Confirmação"
  if (header) {
      header.textContent = 'Confirmação';
  }
  // Seleciona o botão "Sim" (.ajs-ok)
  const botaoSim = document.querySelector('.ajs-ok');
  if (botaoSim) {
      botaoSim.style.backgroundColor = '#28a745'; // Cor de fundo verde (success)
      botaoSim.style.color = 'white'; // Cor do texto branco
      botaoSim.style.border = 'none'; // Remover borda
      botaoSim.style.padding = '10px 20px'; // Espaçamento interno
      botaoSim.style.fontSize = '16px'; // Tamanho da fonte
      botaoSim.style.cursor = 'pointer'; // Cursor de ponteiro
      botaoSim.style.borderRadius = '5px'; // Bordas arredondadas

      // Efeito hover para o botão "Sim"
      botaoSim.addEventListener('mouseover', () => {
          botaoSim.style.backgroundColor = '#218838'; // Verde mais escuro
      });
      botaoSim.addEventListener('mouseout', () => {
          botaoSim.style.backgroundColor = '#28a745'; // Volta ao verde original
      });
  }

  // Seleciona o botão "Não" (.ajs-cancel)
  const botaoNao = document.querySelector('.ajs-cancel');
  if (botaoNao) {
      botaoNao.style.backgroundColor = '#dc3545'; // Cor de fundo vermelho (danger)
      botaoNao.style.color = 'white'; // Cor do texto branco
      botaoNao.style.border = 'none'; // Remover borda
      botaoNao.style.padding = '10px 20px'; // Espaçamento interno
      botaoNao.style.fontSize = '16px'; // Tamanho da fonte
      botaoNao.style.cursor = 'pointer'; // Cursor de ponteiro
      botaoNao.style.borderRadius = '5px'; // Bordas arredondadas

      // Efeito hover para o botão "Não"
      botaoNao.addEventListener('mouseover', () => {
          botaoNao.style.backgroundColor = '#c82333'; // Vermelho mais escuro
      });
      botaoNao.addEventListener('mouseout', () => {
          botaoNao.style.backgroundColor = '#dc3545'; // Volta ao vermelho original
      });
  }  
}

// Mensagens
function setTextoNoAlert(classe, message) {
    $("#mensagem").addClass("alert");
    $('.alert').attr('class', classe);
    $('#mensagem').text(message);
}
function limpar(){
    document.getElementById("form-editar").reset();
    $("#mensagem").empty();
    $("#mensagem").removeClass("alert");
}

// Atualizar dados da solicitação
function editarSolicitacoes() {
    console.log("Editar Dados da solicitação");

    var form = $("#form-editar").serialize(); // já pega motorista=CPF e carro=Renavam
    var dadosFinal = form + '&id=' + idEditar;

    console.log("Dados para enviar:", dadosFinal);

    $.ajax({                    
        type: 'POST',
        url: 'editarSolicitacoes.php',
        cache: false,
        data: dadosFinal,
        success:function (d) {
            console.log("Resposta servidor:", d);
            if(d=='3'){
                setTextoNoAlert('alert btn-success text-center text-white textWhite', 'Sucesso ao Editar!');
                setTimeout(() => window.location.href='administrativo.php', 7000);
            }
            else {
                setTextoNoAlert('alert btn-danger text-center text-white textWhite', 'Erro ao Editar!');
                setTimeout(() => window.location.href='administrativo.php', 10000);
            }
        },
        error: function (xhr, status, error) {
            console.error("Erro no AJAX:", error);
            setTextoNoAlert('alert btn-danger text-center text-white textWhite', 'Erro de comunicação com o servidor!');
        }
    });
}

$(document).ready(function(){
    // Add smooth scrolling to all links in navbar + footer link
    $(".navbar a, footer a[href='#topo']").on('click', function(event) {
      // Make sure this.hash has a value before overriding default behavior
      if (this.hash !== "") {
        // Prevent default anchor click behavior
        event.preventDefault();
    
        // Store hash
        var hash = this.hash;
    
        // Using jQuery's animate() method to add smooth page scroll
        // The optional number (900) specifies the number of milliseconds it takes to scroll to the specified area
        $('html, body').animate({
          scrollTop: $(hash).offset().top
        }, 900, function(){
     
          // Add hash (#) to URL when done scrolling (default click behavior)
          window.location.hash = hash;
        });
      } // End if
    });
    
    $(window).scroll(function() {
      $(".slideanim").each(function(){
        var pos = $(this).offset().top;
    
        var winTop = $(window).scrollTop();
          if (pos < winTop + 600) {
            $(this).addClass("slide");
          }
      });
    });
  })

//Para visualizar os arquivos
// Função para visualizar o arquivo
// Função para visualizar o arquivo (agora recebe parâmetros)
function visualizarArquivo(base64Data, fileName) {
    console.log('Visualizar arquivo chamado:', {
        base64Data: base64Data ? 'presente' : 'ausente',
        fileName: fileName,
        extension: fileName ? fileName.split('.').pop().toLowerCase() : 'none'
    });

    // Verificação mais robusta
    if (!base64Data || base64Data === 'undefined' || base64Data === 'null' || 
        !fileName || fileName === 'undefined' || fileName === 'null') {
        alertify.error('Nenhum arquivo disponível para visualização');
        console.error('Dados faltando ou inválidos:', {
            base64Data: base64Data,
            fileName: fileName,
            typeBase64: typeof base64Data,
            typeFileName: typeof fileName
        });
        return;
    }

    // Verifica se é uma string base64 válida
    if (typeof base64Data !== 'string' || base64Data.length < 100) {
        alertify.error('Arquivo corrompido ou inválido');
        console.error('Base64 inválido:', base64Data);
        return;
    }

    const extension = fileName.split('.').pop().toLowerCase();
    const viewerContent = document.getElementById('fileViewerContent');
    
    if (!viewerContent) {
        alertify.error('Elemento de visualização não encontrado');
        console.error('Elemento #fileViewerContent não existe');
        return;
    }
    
    // Limpa o conteúdo anterior e mostra loading
    viewerContent.innerHTML = '<div class="text-center" style="padding-top: 200px;"><div class="spinner-border" role="status"><span class="sr-only">Carregando...</span></div><p class="mt-2">Carregando arquivo...</p></div>';
    
    // Abre o modal de visualização
    try {
        $('#fileViewerModal').modal('show');
    } catch (error) {
        console.error('Erro ao abrir modal com Bootstrap:', error);
        viewerContent.innerHTML = `
            <div class="alert alert-danger">
                <h5>Erro ao abrir visualizador</h5>
                <p>Não foi possível carregar o visualizador de arquivos.</p>
                <button class="btn btn-primary" onclick="downloadFile('${base64Data}', '${fileName}')">
                    Baixar Arquivo
                </button>
            </div>
        `;
        return;
    }
    
    // Detecta o tipo de arquivo baseado na extensão
    setTimeout(() => {
        try {
            viewerContent.innerHTML = '';
            
            if (['png', 'jpeg', 'jpg'].includes(extension)) {
                exibirImagem(base64Data, viewerContent, fileName);
            } 
            else if (extension === 'pdf') {
                exibirPDF(base64Data, viewerContent, fileName);
            }
            else if (extension === 'txt') {
                exibirTexto(base64Data, viewerContent, fileName);
            }
            else if (extension === 'doc') {
                exibirDocumentoWord(base64Data, fileName, viewerContent);
            }
            else {
                exibirDownloadAlternativo(base64Data, fileName, viewerContent);
            }
        } catch (error) {
            console.error('Erro ao exibir arquivo:', error);
            viewerContent.innerHTML = `
                <div class="alert alert-danger">
                    <h5>Erro ao carregar arquivo</h5>
                    <p>Ocorreu um erro ao tentar visualizar o arquivo.</p>
                    <button class="btn btn-primary" onclick="downloadFile('${base64Data}', '${fileName}')">
                        Baixar Arquivo
                    </button>
                </div>
            `;
        }
    }, 100);
}

// Função para exibir imagens
function exibirImagem(base64Data, container) {
    try {
        const img = document.createElement('img');
        img.src = base64Data;
        img.style.maxWidth = '100%';
        img.style.maxHeight = '100%';
        img.style.display = 'block';
        img.style.margin = '0 auto';
        img.onload = function() {
            container.style.textAlign = 'center';
        };
        
        container.appendChild(img);
    } catch (error) {
        container.innerHTML = `
            <div class="alert alert-danger">
                <h5>Erro ao carregar imagem</h5>
                <p>Não foi possível visualizar a imagem.</p>
            </div>
        `;
    }
}

// Função para exibir PDF (atualizada)
function exibirPDF(base64Data, container, fileName) {
    try {
        // Remove o prefixo data:application/pdf;base64, se existir
        const cleanBase64 = base64Data.includes(',') ? base64Data.split(',')[1] : base64Data;
        
        const byteCharacters = atob(cleanBase64);
        const byteNumbers = new Array(byteCharacters.length);
        
        for (let i = 0; i < byteCharacters.length; i++) {
            byteNumbers[i] = byteCharacters.charCodeAt(i);
        }
        
        const byteArray = new Uint8Array(byteNumbers);
        const blob = new Blob([byteArray], {type: 'application/pdf'});
        const url = URL.createObjectURL(blob);
        
        const iframe = document.createElement('iframe');
        iframe.src = url;
        iframe.style.width = '100%';
        iframe.style.height = '100%';
        iframe.style.minHeight = '450px';
        iframe.style.border = 'none';
        
        container.appendChild(iframe);
        
        // Limpa a URL quando o modal for fechado
        $('#fileViewerModal').on('hidden.bs.modal', function() {
            URL.revokeObjectURL(url);
            $('#fileViewerModal').off('hidden.bs.modal'); // Remove o event listener
        });
        
    } catch (error) {
        console.error('Erro ao exibir PDF:', error);
        container.innerHTML = `
            <div class="alert alert-danger">
                <h5>Erro ao carregar PDF</h5>
                <p>Não foi possível visualizar o arquivo PDF.</p>
                <button class="btn btn-primary" onclick="downloadFile('${base64Data}', '${fileName}')">
                    Baixar Arquivo
                </button>
            </div>
        `;
    }
}

// Função para exibir texto (atualizada)
function exibirTexto(base64Data, container, fileName) {
    try {
        const cleanBase64 = base64Data.includes(',') ? base64Data.split(',')[1] : base64Data;
        const text = atob(cleanBase64);
        
        const pre = document.createElement('pre');
        pre.style.whiteSpace = 'pre-wrap';
        pre.style.wordWrap = 'break-word';
        pre.style.padding = '15px';
        pre.style.backgroundColor = '#f8f9fa';
        pre.style.borderRadius = '5px';
        pre.style.maxHeight = '450px';
        pre.style.overflow = 'auto';
        pre.style.fontFamily = 'monospace';
        pre.style.fontSize = '14px';
        
        pre.textContent = text;
        container.appendChild(pre);
        
    } catch (error) {
        container.innerHTML = `
            <div class="alert alert-danger">
                <h5>Erro ao carregar texto</h5>
                <p>Não foi possível visualizar o arquivo de texto.</p>
                <button class="btn btn-primary" onclick="downloadFile('${base64Data}', '${fileName}')">
                    Baixar Arquivo
                </button>
            </div>
        `;
    }
}

// Função para documentos Word (.doc)
function exibirDocumentoWord(base64Data, fileName, container) {
    container.innerHTML = `
        <div class="alert alert-info">
            <h5>Documento Word</h5>
            <p>Para visualizar documentos Word (.doc), recomendamos:</p>
            <ul>
                <li>Baixar o arquivo e abrir no Microsoft Word</li>
                <li>Usar o Google Docs para visualização online</li>
                <li>Converter para PDF para visualização direta</li>
            </ul>
            <div class="text-center">
                <button class="btn btn-primary mr-2" onclick="downloadFile('${base64Data}', '${fileName}')">
                    <i class="fa fa-download"></i> Baixar Arquivo
                </button>
                <button class="btn btn-success" onclick="abrirNoGoogleDocs('${base64Data}', '${fileName}')">
                    <i class="fa fa-google"></i> Abrir no Google Docs
                </button>
            </div>
        </div>
    `;
}

// Função para abrir no Google Docs (apenas para .doc)
function abrirNoGoogleDocs(base64Data, fileName) {
    try {
        const cleanBase64 = base64Data.includes(',') ? base64Data.split(',')[1] : base64Data;
        const byteCharacters = atob(cleanBase64);
        const byteNumbers = new Array(byteCharacters.length);
        
        for (let i = 0; i < byteCharacters.length; i++) {
            byteNumbers[i] = byteCharacters.charCodeAt(i);
        }
        
        const byteArray = new Uint8Array(byteNumbers);
        const blob = new Blob([byteArray], {type: 'application/msword'});
        const url = URL.createObjectURL(blob);
        
        // Abre no Google Docs
        const googleDocsUrl = `https://docs.google.com/gview?url=${encodeURIComponent(url)}&embedded=true`;
        window.open(googleDocsUrl, '_blank');
        
    } catch (error) {
        alertify.error('Erro ao abrir no Google Docs');
    }
}

// Função para download
function downloadFile(base64Data, fileName) {
    try {
        const link = document.createElement('a');
        link.href = base64Data;
        link.download = fileName;
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
    } catch (error) {
        alertify.error('Erro ao baixar o arquivo');
    }
}

// Função para tipos não suportados
function exibirDownloadAlternativo(base64Data, fileName, container) {
    container.innerHTML = `
        <div class="alert alert-warning">
            <h5>Tipo de arquivo não suportado</h5>
            <p>O formato .${fileName.split('.').pop()} não pode ser visualizado diretamente.</p>
            <button class="btn btn-primary" onclick="downloadFile('${base64Data}', '${fileName}')">
                Baixar Arquivo
            </button>
        </div>
    `;
}

// Adicione esta função para limpar o modal quando fechar
$('#fileViewerModal').on('hidden.bs.modal', function() {
    $('#fileViewerContent').html('');
});

// E também quando o modal de edição fechar, para resetar tudo
$('#modalEditar').on('hidden.bs.modal', function() {
    window.base64 = null;
    window.fileName = null;
    $('#fileViewerContent').html('');
});