<?php
header('Access-Control-Allow-Origin: *');
session_start();

// Inclui o arquivo de conexão com o banco de dados
require_once 'BancodeDados.php';

// Verifica se a conexão foi estabelecida corretamente
if (!isset($pdo)) {
    die(json_encode(['status' => 'error', 'message' => 'Erro: Conexão com o banco de dados não estabelecida.']));
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {   

    // Captura dos dados do formulário enviados via POST  
   
    $data_inicio = $_POST['data_inicio'];
    $hora_inicio = $_POST['hora_inicio'];
    $data_fim = $_POST['data_fim'];
    $hora_fim = $_POST['hora_fim'];
    $motivo = $_POST['motivo'];
    $carro = $_POST['carro'];
    $motorista = $_POST['motorista'];
    $cpf = $_POST['cpfSolicitante'];
    $status = $_POST['status'];
    $obs = $_POST['obs'];
    $id = $_POST['id'];

    // Query SQL para atualizar os dados
    $sql = "UPDATE solicitacoes 
              SET data_inicio = :data_inicio, 
                  hora_inicio = :hora_inicio, 
                  data_fim = :data_fim, 
                  hora_fim = :hora_fim, 
                  motivo = :motivo, 
                  carro = :carro, 
                  cpf = :cpf,
                  motorista = :motorista, 
                  `status` = :status, 
                  obs = :obs 
              WHERE id = :id";

        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':data_inicio' => $data_inicio,
            ':hora_inicio' => $hora_inicio,
            ':data_fim' => $data_fim,
            ':hora_fim' => $hora_fim,
            ':motivo' => $motivo,
            ':carro' => $carro,
            ':motorista' => $motorista,
            ':status' => $status,
            ':obs' => $obs,
            ':cpf' => $cpf,
            ':id' => $id
        ]);

    // Verifica se a query foi executada com sucesso
    if ($stmt->rowCount() > 0) {
        echo '3'; // Sucesso
    } else {
        echo '2'; // Erro
    }
} else {
    echo '4'; // Método não permitido
}
?>