<?php
header('Access-Control-Allow-Origin: *');
session_start();
include_once 'BancodeDados.php'; // deve criar $pdo com PDO

// Verifica se a conexão foi estabelecida corretamente
if (!isset($pdo)) {
    die("Erro: Conexão com o banco de dados não estabelecida.");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $cpf      = $_POST["cpf"] ?? '';
    $senhaOld = $_POST["senhaOld"] ?? '';
    $senhaNew = $_POST["senhaNew"] ?? '';

    if (empty($cpf) || empty($senhaOld) || empty($senhaNew)) {
        echo '1'; // Campos vazios
        exit;
    }

    // Busca senha atual do usuário
    $sql = "SELECT senha FROM usuarios WHERE cpf = :cpf LIMIT 1";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['cpf' => $cpf]);
    $usuario = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$usuario) {
        echo '2'; // Usuário não encontrado
        exit;
    }

    // Verifica se a senha antiga está correta
    if (!password_verify($senhaOld, $usuario['senha'])) {
        echo '4'; // Senha antiga incorreta
        exit;
    }

    // Criptografa a nova senha
    $senhaHash = password_hash($senhaNew, PASSWORD_DEFAULT);

    // Atualiza senha
    $sql = "UPDATE usuarios SET senha = :senha WHERE cpf = :cpf";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'senha' => $senhaHash,
        'cpf'   => $cpf
    ]);

    if ($stmt->rowCount() > 0) {
        echo '3'; // Sucesso
    } else {
        echo '2'; // Erro ao atualizar
    }
} else {
    echo '2'; // Método não permitido
}

