<?php
header('Access-Control-Allow-Origin: *');
session_start();

// Inclui o arquivo de conexão com o banco de dados
require_once 'BancodeDados.php';

// Verifica se a conexão foi estabelecida corretamente
if (!isset($pdo)) {
    die(json_encode(['status' => 'error', 'message' => 'Erro: Conexão com o banco de dados não estabelecida.']));
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verifica se todos os campos necessários estão presentes
    $requiredFields = [
        'nome', 'ano_modelo', 'cpfCnpj', 'renavam', 'placa', 'chassi', 'especieTipo', 
        'marcaModelo', 'capacidade_de_passageiros', 'capPotCil', 'combustivel', 
        'mesCRLV', 'corPredominante', 'anoFabricacao', 'Observacao', 'id'
    ];

    foreach ($requiredFields as $field) {
        if (!isset($_POST[$field])) {
            die('1'); // Erro e interrompe a execução
        }
    }

    // Captura dos dados do formulário enviados via POST
    $nome = $_POST['nome'];
    $anoModelo = $_POST['ano_modelo'];
    $cpfCnpj = $_POST['cpfCnpj'];
    $renavam = $_POST['renavam'];
    $placa = $_POST['placa'];
    $chassi = $_POST['chassi'];
    $especieTipo = $_POST['especieTipo'];
    $marcaModelo = $_POST['marcaModelo'];
    $capacidadeDePassageiros = $_POST['capacidade_de_passageiros'];
    $capPotCil = $_POST['capPotCil'];
    $combustivel = $_POST['combustivel'];
    $mesCRLV = $_POST['mesCRLV'];
    $corPredominante = $_POST['corPredominante'];
    $anoFabricacao = $_POST['anoFabricacao'];
    $observacao = $_POST['Observacao'];
    $id = $_POST["id"];

    // Preparação da query SQL
    $sql = "UPDATE cad_carro SET 
                nome=?, ano_modelo=?, cpf_cnpj=?, renavam=?, placa=?, chassi=?, especie_tipo=?, marca_modelo=?, 
                capacidade_de_passageiros=?, cap_pot_cil=?, combustivel=?, mes_crlv=?, cor_predominante=?, 
                ano_fabricacao=?, observacao=? WHERE id=?";

    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        $nome, $anoModelo, $cpfCnpj, $renavam, $placa, $chassi, $especieTipo, $marcaModelo, 
        $capacidadeDePassageiros, $capPotCil, $combustivel, $mesCRLV, $corPredominante, 
        $anoFabricacao, $observacao, $id
    ]);

    // Verifica se a query foi executada com sucesso
    if ($stmt->rowCount() > 0) {
        echo '3'; // Sucesso
    } else {
        echo '2'; // Erro
    }
} else {
    echo '4'; // Método não permitido
}
?>