<?php
header('Access-Control-Allow-Origin: *');
session_start();

// Inclui o arquivo de conexão com o banco de dados
require_once 'BancodeDados.php';

// Verifica se a conexão foi estabelecida corretamente
if (!isset($pdo)) {
    die(json_encode(['status' => 'error', 'message' => 'Erro: Conexão com o banco de dados não estabelecida.']));
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {   

    // Captura dos dados do formulário enviados via POST  
    $id =  (int)$_POST["id"];

    // Preparação da query SQL
    $sql = "DELETE FROM solicitacoes WHERE id=?";

    $stmt = $pdo->prepare($sql);
    $stmt->execute([$id]);

    // Verifica se a query foi executada com sucesso
    if ($stmt->rowCount() > 0) {
        echo '3'; // Sucesso
    } else {
        echo '2'; // Erro
    }
} else {
    echo '4'; // Método não permitido
}
?>