<?php
header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Methods: GET,PUT,POST,DELETE");
header('Content-Type: application/json; charset=utf-8');

session_start();
ob_start();

include_once 'BancodeDados.php'; // este arquivo deve instanciar $pdo com PDO

// Recebe dados via POST
$nome    = $_POST["nome"]    ?? '';
$cpf     = $_POST["cpf"]     ?? '';
$email   = $_POST["email"]   ?? '';
$usuario = $_POST["usuario"] ?? '';
$perfil  = $_POST["perfil"]  ?? '';
$senha1  = $_POST["senha"]   ?? '';

if (empty($nome) || empty($cpf) || empty($email) || empty($usuario) || empty($perfil) || empty($senha1)) {
    echo json_encode('0'); // Campos vazios
    exit;
}

// Criptografa a senha
$senha = password_hash($senha1, PASSWORD_DEFAULT);

try {
    // Usa prepared statement para evitar SQL Injection
    $sql = "INSERT INTO usuarios (nome, cpf, email, usuario, perfil, senha) 
            VALUES (:nome, :cpf, :email, :usuario, :perfil, :senha)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':nome'    => $nome,
        ':cpf'     => $cpf,
        ':email'   => $email,
        ':usuario' => $usuario,
        ':perfil'  => $perfil,
        ':senha'   => $senha
    ]);

    if ($stmt->rowCount() > 0) {
        echo json_encode('1'); // sucesso
    } else {
        echo json_encode('2'); // falha ao inserir
    }
} catch (PDOException $e) {
    echo json_encode(['erro' => $e->getMessage()]);
}
